using System.Windows.Forms;
using System.Collections.Specialized;
using Borland.Eco.Persistence;

namespace Borland.Eco.Examples.CleanPS
{
  public sealed class ForcedCleaning: System.Object, IConfigureCleanPS
  {
	public ForcedCleaning() {}
	public StringCollection DetermineTablesToDelete(StringCollection allTables, StringCollection knownTables, StringCollection SQLTables)
		{
			return allTables;
		}
		public void InstallExternalSystemTables(StringCollection tableNames)
		{
			// ignore external system tables
		}
	}
  public sealed class CleanAndAskALot: System.Object, IConfigureCleanPS
  {
	public CleanAndAskALot() {}
		public void InstallExternalSystemTables(StringCollection tableNames)
		{
			// ignore external system tables
		}
		public StringCollection DetermineTablesToDelete(StringCollection allTables, StringCollection knownTables, StringCollection SQLTables)
		{
			string tableName;
			StringCollection deleteTables = new StringCollection();

			for (int i = 0; i < allTables.Count; i++)
			{
				tableName = allTables[i].ToUpper();
				if (knownTables.Contains(tableName) ||
					SQLTables.Contains(tableName))
				{
					if (MessageBox.Show(System.String.Format("Do you want to keep delete {0}?", tableName), "Delete table", MessageBoxButtons.YesNo) == DialogResult.Yes)
						deleteTables.Add(tableName);
				}
			}
			return deleteTables;
		}
	}
}